/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.user;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.list.AbstractListModelBuilder;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import org.apache.log4j.Logger;

public class FolderList extends List {
    public FolderList() {
        super(new FolderListModelBuilder());
        
        setCellRenderer(new CellRenderer());
    }
    
    public final boolean isVisible(final PageState state) {
        return CMS.getContext().hasContentItem() && super.isVisible(state);
    }

    private static class FolderListModelBuilder
            extends AbstractListModelBuilder {
        public final ListModel makeModel(final List list,
                                         final PageState state) {
            final Folder parent = (Folder) CMS.getContext().getContentItem();

            final DataCollection folders =
                SessionManager.getSession().retrieve(Folder.BASE_DATA_OBJECT_TYPE);

            folders.addEqualsFilter(ContentItem.PARENT, parent.getID());
            folders.addOrder("lower(" + ACSObject.DISPLAY_NAME + ")");

            return new Model(new ItemCollection(folders));
        }

        private class Model implements ListModel {
            private final ItemCollection m_items;

            Model(final ItemCollection items) {
                m_items = items;
            }

            public final boolean next() {
                if (m_items.next()) {
                    return true;
                } else {
                    m_items.close();

                    return false;
                }
            }

            public final Object getElement() {
                return m_items.getDisplayName();
            }

            public final String getKey() {
                return m_items.getName() + "/";
            }
        }
    }

    private class CellRenderer implements ListCellRenderer {
        public final Component getComponent(final List list,
                                            final PageState state,
                                            final Object value,
                                            final String key,
                                            final int index,
                                            final boolean isSelected) {
            return new Link((String) value, key);
        }
    }

}
