/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.kernel.Party;
import com.arsdigita.toolbox.ui.SecurityContainer;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/type/TypeSecurityContainer.java#6 $
 */
public final class TypeSecurityContainer extends SecurityContainer {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/type/TypeSecurityContainer.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log = Logger.getLogger(TypeSecurityContainer.class);

    public TypeSecurityContainer(final Component c) {
        super(c);
    }

    protected final boolean canAccess(final Party party,
                                      final PageState state) {
        final SecurityManager sm = Utilities.getSecurityManager(state);

        return sm.canAccess(party, SecurityManager.CONTENT_TYPE_ADMIN);
    }
}
