/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.util.LockableImpl;

import java.util.NoSuchElementException;

/**
 * Builds a dynamic list of content types for a content section.
 */
class ContentTypeListModelBuilder extends LockableImpl
        implements ListModelBuilder {
    public ListModel makeModel(List l, final PageState state) {
        return new Model();
    }

    private class Model implements ListModel {
        private ContentTypeCollection m_types;

        Model() {
            final ContentSection section =
                CMS.getContext().getContentSection();

            m_types = section.getContentTypes();
            m_types.addOrder(ContentType.LABEL);
            m_types.rewind();
        }

        public boolean next() throws NoSuchElementException {
            return m_types.next();
        }

        public Object getElement() {
            return m_types.getContentType().getLabel();
        }

        public String getKey() {
            return m_types.getContentType().getID().toString();
        }
    }
}
