/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Date;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.formbuilder.PersistentDate;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.metadata.MetadataRoot;

/**
 * This class contains the form component for adding a date element to
 * a content type
 *
 * @author Xixi D'Moon (xdmoon@arsdigita.com)
 * @author Stanislav Freidin (sfreidin@arsdigita.com)
 * @version $Revision: #13 $ $Date: 2004/04/07 $
 */
public class AddDateElement extends ElementAddForm {

    private Date m_date;
    private CheckboxGroup m_valReq;  //whether a value is requred
    private TextField m_fromYear, m_toYear;

    /**
     * Constructor
     */
    public AddDateElement(ACSObjectSelectionModel types) {
        super("ContentTypeAddDateElement", "Add a Date Element", types);

        add(new Label(GlobalizationUtil.globalize
                      ("cms.ui.type.element.value_required")));
        m_valReq = new CheckboxGroup("AddDateElementValReq");
        // XXX fix l18n wrt request
        m_valReq.addOption(new Option(lz("cms.ui.no"), lz("cms.ui.yes")));
        add(m_valReq);

        add(new Label(GlobalizationUtil.globalize
                      ("cms.ui.type.default_date")));
        m_date = new Date("elementdate");
        long cur = System.currentTimeMillis();
        java.util.Date curtime = new java.util.Date(cur);
        m_date.setDefaultValue(curtime);
        m_date.setClassAttr("AddDateElementChooseDate");
        add(m_date);

        add(new Label(GlobalizationUtil.globalize
                      ("cms.ui.type.year_range")));

        m_fromYear = new TextField(new IntegerParameter("fromYear"));
        m_fromYear.setSize(6);
        m_fromYear.setMaxLength(4);
        m_toYear = new TextField(new IntegerParameter("toYear"));
        m_toYear.setSize(6);
        m_toYear.setMaxLength(4);

        FormSection rangeSec = new FormSection
            (new BoxPanel(BoxPanel.HORIZONTAL, false));

        rangeSec.add(new Label(GlobalizationUtil.globalize("cms.ui.type.from")));
        rangeSec.add(m_fromYear);
        rangeSec.add(new Label(GlobalizationUtil.globalize("cms.ui.type.to")));
        rangeSec.add(m_toYear);
        add(rangeSec);

        add(m_buttons, ColumnPanel.FULL_WIDTH|ColumnPanel.CENTER);
    }


    protected final void addAttribute(DynamicObjectType dot, String label,
                                      PageState state)
        throws FormProcessException {

        java.util.Date date = (java.util.Date) m_date.getValue(state);
        String[] valReq = (String[]) m_valReq.getValue(state);

        if (valReq == null) {
            dot.addOptionalAttribute(label, MetadataRoot.DATE);
        } else {
            dot.addRequiredAttribute(label, MetadataRoot.DATE, date);
        }
    }


    protected final void addFormComponent(PersistentForm pForm, String label,
                                          PageState state)
        throws FormProcessException {

        PersistentDate pDate = PersistentDate.create(label);
        pDate.setParameterModel("com.arsdigita.bebop.parameters.DateParameter");
        pForm.addComponent(pDate);
    }

    /**
     * Initializes date widget to current date.
     */
    protected final void doInit(FormSectionEvent event) {
        java.util.Date date = new java.util.Date(System.currentTimeMillis());
        m_date.setValue(event.getPageState(), date);
    }

    protected final void doValidate(FormSectionEvent e)
        throws FormProcessException {

        PageState state = e.getPageState();

        Integer fromYear = (Integer) m_fromYear.getValue(state);
        Integer toYear = (Integer) m_toYear.getValue(state);

        if (!(fromYear != null && toYear != null)) {
            throw new FormProcessException
                ((String) GlobalizationUtil.globalize
                 ("cms.ui.type.year_range_not_balanced").localize());
        } else {
            if ((fromYear.intValue() < 0) || (toYear.intValue() < 0)) {
                throw new FormProcessException
                    ((String) GlobalizationUtil.globalize
                     ("cms.ui.type.year_is_negative").localize());
            }

            if (fromYear.intValue() > toYear.intValue()) {
                throw new FormProcessException
                    ((String) GlobalizationUtil.globalize
                     ("cms.ui.type.year_range_wrong_order").localize());
            }

            if ((toYear.intValue() - fromYear.intValue()) > 200) {
                throw new FormProcessException
                    ((String) GlobalizationUtil.globalize
                     ("cms.ui.type.year_range_too_great").localize());
            }

            if ((fromYear.intValue() < 1900 || fromYear.intValue() > 2100) &&
                 (toYear.intValue() < 1900 || toYear.intValue() > 2100)) {
                throw new FormProcessException
                    ((String) GlobalizationUtil.globalize
                     ("cms.ui.type.year_too_anachronistic").localize());
            }
        }
    }

    private static String lz(final String key) {
        return (String) GlobalizationUtil.globalize(key).localize();
    }
}
