/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.search;

import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.ui.StaticFilterComponent;
import com.arsdigita.cms.search.VersionFilterSpecification;
import com.arsdigita.bebop.PageState;

/**
 * A simple filter generator that restricts to a 
 * specified set of object types
 */
public class VersionFilterComponent extends StaticFilterComponent {

    private String m_version;
    
    /**
     * Creates a filter generator restricting to a specific
     * content item version
     * 
     * @param type the version
     */
    public VersionFilterComponent(String version) {
        m_version = version;
    }

    public FilterSpecification getFilter(PageState state) {
        return new VersionFilterSpecification(
            m_version
        );
    }

}
