/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.search;

import com.arsdigita.bebop.PageState;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.ui.BaseQueryComponent;
import com.arsdigita.search.ui.filters.PermissionFilterComponent;
import com.arsdigita.search.ui.filters.SimpleCategoryFilterWidget;
import com.arsdigita.search.ui.filters.DateRangeFilterWidget;
import com.arsdigita.search.ui.filters.PartyFilterWidget;
import com.arsdigita.cms.search.LaunchDateFilterType;
import com.arsdigita.cms.search.CreationDateFilterType;
import com.arsdigita.cms.search.LastModifiedDateFilterType;
import com.arsdigita.cms.search.LastModifiedUserFilterType;
import com.arsdigita.cms.search.CreationUserFilterType;
import com.arsdigita.search.Search;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.ui.ContentSectionPage;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.web.Application;

import java.util.List;
import java.util.ArrayList;

/**
 * This class provides a basic query form for CMS admin pages
 * that automatically adds components for the maximal set of
 * filters supported by the current search query engine.
 */
public class ItemQueryComponent extends BaseQueryComponent {
    
    private String m_context;

    public ItemQueryComponent(String context) {
        m_context = context;

        if (Search.getConfig().isIntermediaEnabled()) {
            add(new PermissionFilterComponent(
                    SecurityManager.CMS_READ_ITEM));

            if (CMS.getContext().hasContentSection()) {
                ContentSection section = CMS.getContext().getContentSection();
                add(new SimpleCategoryFilterWidget(section.getRootCategory()));
            } else {
                ContentSectionCollection sections = 
                    ContentSection.getAllSections();

                List cats = new ArrayList();
                while (sections.next()) {
                    ContentSection section = sections.getContentSection();
                    cats.add(section.getRootCategory());
                }
                add(new SimpleCategoryFilterWidget(
                        (Category[])cats.toArray(new Category[cats.size()])));
            }
            add(new LaunchDateFilterWidget(new LaunchDateFilterType(), 
                                          LaunchDateFilterType.KEY));
        }

        if (Search.getConfig().isIntermediaEnabled() ||
            Search.getConfig().isLuceneEnabled()) {

            if (CMS.getContext().hasContentSection()) {
                ContentSection section = CMS.getContext().getContentSection();
                add(new ContentTypeFilterWidget(section));
            } else {
                add(new ContentTypeFilterWidget());
            }

            add(new VersionFilterComponent(context));
            add(new DateRangeFilterWidget(new LastModifiedDateFilterType(), 
                                          LastModifiedDateFilterType.KEY));
            add(new DateRangeFilterWidget(new CreationDateFilterType(), 
                                          CreationDateFilterType.KEY));
            add(new PartyFilterWidget(new CreationUserFilterType(),
                                      CreationUserFilterType.KEY));
            add(new PartyFilterWidget(new LastModifiedUserFilterType(),
                                      LastModifiedUserFilterType.KEY));
        }
        
        Submit submit = new Submit(m_context + "_search",  
                                   ContentSectionPage.globalize("cms.ui.search"));
        add(submit);
    }

    private class LaunchDateFilterWidget extends DateRangeFilterWidget {
        public LaunchDateFilterWidget(FilterType type, String name) {
            super(type,name);

        }
        public boolean isVisible(PageState state) {
            return !ContentSection.getConfig().getHideLaunchDate() &&
                super.isVisible(state);
        }

    }
}
