/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.portlet;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.portal.PortletConfigFormSection;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.MultilingualItemResolver;
import com.arsdigita.cms.portlet.ContentItemPortlet;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.portal.Portlet;
import com.arsdigita.web.Application;
import com.arsdigita.web.URL;
import org.apache.log4j.Logger;

public class ContentItemPortletEditor extends PortletConfigFormSection {

    private static final Logger s_log =
        Logger.getLogger( ContentItemPortletEditor.class );

    private TextField m_url;

    private RequestLocal m_contentItem = new RequestLocal() {
            protected Object initialValue( PageState ps ) {
                String url = (String) m_url.getValue(ps);
                String dp = URL.getDispatcherPath();

                if ( url.startsWith(dp) ) {
                    url = url.substring(dp.length());
                }

                SiteNode node = null;

                try {
                    node = SiteNode.getSiteNode(url);
                } catch (DataObjectNotFoundException ex) {
                    s_log.debug( "Couldn't fetch sitenode for " + url );
                    return null;
                }

                ContentSection section = null;
                section = ContentSection.getSectionFromNode(node);
                ItemResolver resolver = section.getItemResolver();

                String base = node.getURL();
                url = url.substring(base.length(), url.length());

                if (url.endsWith(".jsp")) {
                    url = url.substring(0, url.length()-4);
                }

                ContentItem item = resolver.getItem(section, url, ContentItem.LIVE);
                if (item == null) {
                    s_log.debug( "Couldn't resolve item " + url );
                    return null;
                }

                return item;
            }
        };

    public ContentItemPortletEditor(ResourceType resType,
                                    RequestLocal parentAppRL) {
        super(resType, parentAppRL);
    }

    public ContentItemPortletEditor(RequestLocal application) {
        super(application);
    }

    public void addWidgets() {
        super.addWidgets();
        m_url = new TextField(new StringParameter("url"));
        m_url.setSize(50);
        m_url.addValidationListener(new NotNullValidationListener());
        m_url.addValidationListener(new StringInRangeValidationListener(1, 250));

        add(new Label("Item URL:", Label.BOLD), ColumnPanel.RIGHT);
        add(m_url);
    }

    public void initWidgets(PageState state,
                            Portlet portlet)
        throws FormProcessException {
        super.initWidgets(state, portlet);

        if (portlet != null) {
            ContentItemPortlet myportlet = (ContentItemPortlet)portlet;
            ItemResolver resolver = new MultilingualItemResolver();
            ContentItem item = myportlet.getContentItem();
            if (item != null) {
                m_url.setValue(state, resolver.generateItemURL(state, item,
                                                               item.getContentSection(),
                                                               ContentItem.LIVE));
            } else {
                m_url.setValue(state, "");
            }
        }
    }

    public void validateWidgets(PageState state,
                                Portlet portlet)
        throws FormProcessException {
        super.validateWidgets(state, portlet);

        Object item = m_contentItem.get( state );
        if (item == null)
            throw new FormProcessException("cannot find content item");
    }

    public void processWidgets(PageState state,
                               Portlet portlet)
        throws FormProcessException {
        super.processWidgets(state, portlet);

        ContentItem item = (ContentItem) m_contentItem.get( state );

        ContentItemPortlet myportlet = (ContentItemPortlet)portlet;
        myportlet.setContentItem(item);
    }
}
