/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.permissions;

import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;

/**
 * This interface is used to centralize constants and labels used in
 * the Permissions UI package.
 *
 * @author Stefan Deusch (stefan@arsdigita.com)
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/permissions/CMSPermissionsConstants.java#7 $
 */

interface CMSPermissionsConstants {

    /**
     * These are our five default privileges.
     */

    PrivilegeDescriptor[] DEFAULT_PRIVILEGES = new PrivilegeDescriptor[] {
        PrivilegeDescriptor.READ,
        PrivilegeDescriptor.WRITE,
        PrivilegeDescriptor.CREATE,
        PrivilegeDescriptor.DELETE,
        PrivilegeDescriptor.ADMIN
    };


    String BUNDLE_NAME = "com.arsdigita.ui.permissions.PermissionsResources";

    GlobalizedMessage SEARCH_LABEL =  new GlobalizedMessage
        ("permissions.userSearchForm.label", BUNDLE_NAME);

    GlobalizedMessage SEARCH_BUTTON = new GlobalizedMessage
        ("permissions.button.search", BUNDLE_NAME);

    GlobalizedMessage SAVE_BUTTON = new GlobalizedMessage
        ("permissions.button.save", BUNDLE_NAME);

    GlobalizedMessage NO_RESULTS = new GlobalizedMessage
        ("permissions.userSearchForm.noResults", BUNDLE_NAME);


    // Direct / Indirect permissions

    GlobalizedMessage PERM_TABLE_DIRECT_HEADING = new GlobalizedMessage
        ("permissions.directPermissions.heading", BUNDLE_NAME);

    GlobalizedMessage PERM_TABLE_DIRECT_EXPLANATION = new GlobalizedMessage
        ("permissions.directPermissions.explanation", BUNDLE_NAME);

    GlobalizedMessage PERM_TABLE_INDIRECT_HEADING = new GlobalizedMessage
        ("permissions.indirectPermissions.heading", BUNDLE_NAME);

    GlobalizedMessage PERM_TABLE_INDIRECT_EXPLANATION = new GlobalizedMessage
        ("permissions.indirectPermissions.explanation", BUNDLE_NAME);

    GlobalizedMessage PERM_TABLE_INDIRECT_CONTEXT = new GlobalizedMessage
        ("permissions.indirectPermissions.context", BUNDLE_NAME);

    GlobalizedMessage PERM_TABLE_GRANTEE =  new GlobalizedMessage
        ("permissions.table.grantee", BUNDLE_NAME);

    GlobalizedMessage PERM_TABLE_ACTIONS = new GlobalizedMessage
        ("permissions.table.actions",  BUNDLE_NAME);

    GlobalizedMessage REMOVE_ALL_CONFIRM = new GlobalizedMessage
        ("permissions.table.actions.removeAll",  BUNDLE_NAME);

    GlobalizedMessage PERM_TABLE_INHERITED = new GlobalizedMessage
        ("permissions.table.inherited",  BUNDLE_NAME);

    GlobalizedMessage PERM_TABLE_NO_PARENT_CONTEXT = new GlobalizedMessage
        ("permissions.table.parent.context.null",  BUNDLE_NAME);


    // Permissions header

    GlobalizedMessage PAGE_TITLE = new GlobalizedMessage
        ("permissions.one.title", BUNDLE_NAME);

    GlobalizedMessage MAIN_SITE = new GlobalizedMessage
        ("permissions.main.site", BUNDLE_NAME);

    GlobalizedMessage PERSONAL_SITE = new GlobalizedMessage
        ("permissions.personal.site", BUNDLE_NAME);

    GlobalizedMessage PERMISSIONS_INDEX = new GlobalizedMessage
        ("permissions.index.title", BUNDLE_NAME);

    GlobalizedMessage PERMISSIONS_INDEX_NAVBAR = new GlobalizedMessage
        ("permissions.index.navbarItem", BUNDLE_NAME);

    // Permissions grant form

    GlobalizedMessage PAGE_GRANT_TITLE = new GlobalizedMessage
        ("permissions.one.grant.title",BUNDLE_NAME);

    GlobalizedMessage PAGE_GRANT_LEFT = new GlobalizedMessage
        ("permissions.one.grant.explanation.left", BUNDLE_NAME);

    GlobalizedMessage PAGE_GRANT_RIGHT = new GlobalizedMessage
        ("permissions.one.grant.explanation.right", BUNDLE_NAME);

    // Access denied page

    GlobalizedMessage PAGE_DENIED_TITLE =  new GlobalizedMessage
        ("permissions.denied.title", BUNDLE_NAME);

    // Index page

    GlobalizedMessage PAGE_OBJECT_INDEX =  new GlobalizedMessage
        ("permissions.index.adminObjects", BUNDLE_NAME);

    GlobalizedMessage PAGE_OBJECT_PANEL_TITLE = new GlobalizedMessage
        ("permissions.index.panelTitle", BUNDLE_NAME);

    GlobalizedMessage PAGE_OBJECT_NONE =  new GlobalizedMessage
        ("permissions.index.noAdminObjects", BUNDLE_NAME);

    // Flats for permission types

    int DIRECT    = 0;
    int INHERITED = 1;

    // Form constants

    String OBJECT_ID = "po_id";
    String DIRECT_PERMISSIONS = "direct";
    String INDIRECT_PERMISSIONS = "indirect";
    String SEARCH_QUERY = "query";
    String PRIV_SET = "privs_set";


    // shared query
    String RETRIEVE_USERS = "com.arsdigita.kernel.RetrieveUsers";
}
