/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.lifecycle.Phase;
import com.arsdigita.cms.lifecycle.PhaseCollection;
import com.arsdigita.cms.util.GlobalizationUtil;

import java.text.DateFormat;

/**
 * @author Xixi D'Moon &lt;xdmoon@arsdigita.com&gt;
 * @author Michael Pih
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/ItemPhaseTableModelBuilder.java#7 $
 */
class ItemPhaseTableModelBuilder extends AbstractTableModelBuilder {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/ItemPhaseTableModelBuilder.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private final LifecycleRequestLocal m_lifecycle;

    public ItemPhaseTableModelBuilder(final LifecycleRequestLocal lifecycle) {
        m_lifecycle = lifecycle;
    }

    public final TableModel makeModel(final Table table,
                                      final PageState state) {
        return new Model(m_lifecycle.getLifecycle(state).getPhases());
    }

    private static class Model implements TableModel {
        private final PhaseCollection m_phases;
        private Phase m_phase;

        public Model(final PhaseCollection phases) {
            m_phases = phases;
        }

        public final int getColumnCount() {
            return 4;
        }

        public final boolean nextRow() {
            if (m_phases.next()) {
                m_phase = m_phases.getPhase();

                return true;
            } else {
                m_phases.close();

                return false;
            }
        }

        public final Object getElementAt(final int column) {
            final DateFormat format = DateFormat.getDateTimeInstance
                (DateFormat.FULL, 
                 ContentSection.getConfig().getHideTimezone() ? DateFormat.SHORT : DateFormat.FULL);

            switch (column) {
            case 0:
                return m_phase.getLabel();
            case 1:
                return m_phase.getPhaseDefinition().getDescription();
            case 2:
                final java.util.Date startDate = m_phase.getStartDate();
                return format.format(startDate);
            case 3:
                final java.util.Date endDate = m_phase.getEndDate();

                if (endDate == null) {
                    return lz("cms.ui.lifecycle.forever");
                } else {
                    return format.format(endDate);
                }
            default:
                throw new IllegalArgumentException();
            }
        }

        public final Object getKeyAt(final int column) {
            return m_phase.getPhaseDefinition().getID();
        }
    }

    protected final static String lz(final String key) {
        return (String) GlobalizationUtil.globalize(key).localize();
    }
}
