/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.toolbox.ui.LayoutPanel;
import org.apache.log4j.Logger;

/**
 * @author Michael Pih
 * @author Jack Chung
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/ItemLifecycleAdminPane.java#12 $
 */
public class ItemLifecycleAdminPane extends BaseItemPane {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/ItemLifecycleAdminPane.java#12 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (ItemLifecycleAdminPane.class);

    private final ContentItemRequestLocal m_item;
    private final LifecycleRequestLocal m_lifecycle;

    private final LayoutPanel m_introPane;
    private final LayoutPanel m_detailPane;
    private final LayoutPanel m_selectPane;

    public ItemLifecycleAdminPane(final ContentItemRequestLocal item) {
        m_item = item;
        m_lifecycle = new ItemLifecycleRequestLocal();

        m_introPane = new LayoutPanel();
        add(m_introPane);

        final Label message = new Label(gz("cms.ui.item.lifecycle.intro"));
        m_introPane.setBody(message);

        m_detailPane = new LayoutPanel();
        add(m_detailPane);

        final ItemLifecycleItemPane itemPane =
            new ItemLifecycleItemPane(m_item, m_lifecycle);
        m_detailPane.setBody(itemPane);

        m_selectPane = new LayoutPanel();
        add(m_selectPane);

        final ItemLifecycleSelectForm selectForm =
            new ItemLifecycleSelectForm(m_item);
        m_selectPane.setBody(selectForm);

        connect(selectForm, m_detailPane);
    }

    private class ItemLifecycleRequestLocal extends LifecycleRequestLocal {
        protected final Object initialValue(final PageState state) {
            final ContentItem item = m_item.getContentItem(state);
            final Lifecycle lifecycle = item.getLifecycle();

            s_log.debug("Returning lifecycle " + lifecycle);

            return lifecycle;
        }
    }

    public final void register(final Page page) {
        super.register(page);

        page.addActionListener(new VisibilityListener());
    }

    private class VisibilityListener implements ActionListener {
        public final void actionPerformed(final ActionEvent e) {
            s_log.debug("Determining which pane to show");

            final PageState state = e.getPageState();

            if (state.isVisibleOnPage(ItemLifecycleAdminPane.this)) {
                if (m_lifecycle.getLifecycle(state) == null) {
                    if (hasPermission(state)) {
                        push(state, m_selectPane);
                    } else {
                        push(state, m_introPane);
                    }
                } else {
                    push(state, m_detailPane);
                }
            }
        }
    }

    private boolean hasPermission(final PageState state) {
        final ContentItem item = m_item.getContentItem(state);

        return CMS.getContext().getSecurityManager().canAccess
            (state.getRequest(), SCHEDULE_PUBLICATION, item);
    }
}
