/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.item;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.workflow.simple.Workflow;
import org.apache.log4j.Logger;

public class ItemWorkflowRequestLocal extends WorkflowRequestLocal {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/item/ItemWorkflowRequestLocal.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (ItemWorkflowRequestLocal.class);

    protected final Object initialValue(final PageState state) {
        final ContentItem item = CMS.getContext().getContentItem();

        return Workflow.getObjectWorkflow(item);
    }
}
