/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.util.LockableImpl;

/**
 * Produce a list of the items starting from the selected item's root down
 * to the item itself.
 *
 * @author <a href="mailto:lutter@arsdigita.com">David Lutterkort</a>
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/folder/ItemPath.java#7 $
 */
public class ItemPath extends List {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/folder/ItemPath.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public ItemPath(ItemSelectionModel folderSel) {
        super(new ListModelBuilder(folderSel));
        setAttribute("type", "item-path");
        setSelectionModel(folderSel);
    }

    public static class ListModel
        implements com.arsdigita.bebop.list.ListModel {
        ItemCollection m_coll;

        public ListModel(ContentItem i) {
            m_coll = i.getPathInfo(true);
        }

        public boolean next() {
            return m_coll.next();
        }

        public Object getElement() {
            return m_coll.getName();
        }

        public String getKey() {
            return m_coll.getID().toString();
        }
    }

    public static class ListModelBuilder extends LockableImpl
        implements com.arsdigita.bebop.list.ListModelBuilder {

        ItemSelectionModel m_itemSel;

        public ListModelBuilder(ItemSelectionModel itemSel) {
            m_itemSel = itemSel;
        }

        public com.arsdigita.bebop.list.ListModel makeModel(List l, final PageState s) {
            return new ListModel((ContentItem) m_itemSel.getSelectedObject(s));
        }
    }
}
