/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.Folder;
import org.apache.log4j.Logger;

class FolderEditForm extends FolderBaseForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/folder/FolderEditForm.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log = Logger.getLogger(FolderEditForm.class);

    private final FolderRequestLocal m_folder;

    public FolderEditForm(final FolderRequestLocal folder) {
        super("folder-edit");

        m_folder = folder;

        // XXX need to do name uniqueness valdation on m_fragment here
        // as well.

        addInitListener(new InitListener());
        addProcessListener(new ProcessListener());
    }

    private static FolderRequestLocal parent(final FolderRequestLocal folder) {
        final FolderRequestLocal parent = new FolderRequestLocal(null) {
                protected final Object initialValue(final PageState state) {
                    return (Folder) folder.getFolder(state).getParent();
                }
            };

        return parent;
    }

    private class InitListener implements FormInitListener {
        public final void init(final FormSectionEvent e) {
            final PageState state = e.getPageState();

            final Folder folder = m_folder.getFolder(state);

            m_title.setValue(state, folder.getLabel());
            m_fragment.setValue(state, folder.getName());
        }
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();

            final Folder folder = m_folder.getFolder(state);

            folder.setLabel((String) m_title.getValue(state));
            folder.setName((String) m_fragment.getValue(state));

            folder.save();
        }
    }
}
