/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import org.apache.log4j.Logger;

/**
 * Class FolderForm implements the basic form for creating or renaming
 * folders.
 *
 * @author Jon Orris &lt;jorris@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/folder/FolderBaseForm.java#5 $
 */
abstract class FolderBaseForm extends CMSForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/folder/FolderBaseForm.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log = Logger.getLogger(FolderBaseForm.class);

    public static final String NAME = ContentItem.NAME;
    public static final String TITLE = ContentPage.TITLE;

    private static final String TITLE_ON_FOCUS =
        "if (this.form." + NAME + ".value == '') {" +
        "    defaulting = true;" +
        "    this.form." + NAME + ".value = urlize(this.value);" +
        "}";

    private static final String TITLE_ON_KEY_UP =
        "if (defaulting) {" +
        "    this.form." + NAME + ".value = urlize(this.value)" +
        "}";

    private static final String FRAGMENT_ON_FOCUS = "defaulting = false";

    private static final String FRAGMENT_ON_BLUR =
        "if (this.value == '') {" +
        "    defaulting = true;" +
        "    this.value = urlize(this.form." + TITLE + ".value)" +
        "}";

    private final Label m_script = new Label
        ("<script language=\"javascript\">" +
         "    var defaulting = false;" +
         "" +
         "    function urlize(title) {" +
         "        var result = \"\";" +
         "        for (var i = 0; i < title.length; i++) {" +
         "            result = result + substitute(title.charAt(i));" +
         "        }" +
         "        return escape(result);" +
         "    }" +
         "" +
         "    function substitute(c) {" +
         "        switch (c) {" +
         "            case \" \":" +
         "                return \"-\";" +
         "            case \"'\":" +
         "            case \",\":" +
         "            case \":\":" +
         "            case \";\":" +
         "            case \"?\":" +
         "            case \"!\":" +
         "                return \"\";" +
         "            default:" +
         "                return c.toLowerCase();" +
         "        }" +
         "    }" +
         "</script>",
         false);

    final TextField m_title;
    final TextField m_fragment;
    final SaveCancelSection m_submits;

    public FolderBaseForm(final String name) {
        super(name);

        add(m_script, GridPanel.FULL_WIDTH);

        // Title

        add(new Label(gz("cms.ui.folder.name")));

        m_title = new TextField(new TrimmedStringParameter(TITLE));
        add(m_title);

        m_title.addValidationListener(new NotNullValidationListener());
        m_title.setOnFocus(TITLE_ON_FOCUS);

        m_title.setOnFocus(TITLE_ON_FOCUS);
        m_title.setOnKeyUp(TITLE_ON_KEY_UP);

        // Fragment

        add(new Label(gz("cms.ui.folder.fragment")));

        m_fragment = new TextField(new TrimmedStringParameter(NAME));
        add(m_fragment);

        m_fragment.addValidationListener(new NotNullValidationListener());

        m_fragment.setOnFocus(FRAGMENT_ON_FOCUS);
        m_fragment.setOnBlur(FRAGMENT_ON_BLUR);

        m_submits = new SaveCancelSection();
        add(m_submits, GridPanel.FULL_WIDTH);
    }

    public final boolean isCancelled(final PageState state) {
        return m_submits.getCancelButton().isSelected(state);
    }

    private static GlobalizedMessage gz(final String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(final String key) {
        return (String) gz(key).localize();
    }
}
