/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.AbstractListModelBuilder;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.RootCategoryCollection;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import org.apache.log4j.Logger;

/**
 * Builds a list of category use contexts for the current
 * content section.
 *
 * @author Scott Seago 
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryUseContextModelBuilder.java#3 $
 */
class CategoryUseContextModelBuilder extends AbstractListModelBuilder {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryUseContextModelBuilder.java#3 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    public static String DEFAULT_USE_CONTEXT = "<default>";

    private static final Logger s_log = Logger.getLogger
        (CategoryUseContextModelBuilder.class);

    public final ListModel makeModel(final List list, final PageState state) {
        return new Model();
    }

    private class Model implements ListModel {
        private final RootCategoryCollection m_roots;

        public Model() {
            final ContentSection section =
                CMS.getContext().getContentSection();

            m_roots = Category.getRootCategories(section);
            m_roots.addOrder(Category.USE_CONTEXT);
        }

        public boolean next() {
            return m_roots.next();
        }

        public Object getElement() {
            String useContext = m_roots.getUseContext();
            return useContext == null ? DEFAULT_USE_CONTEXT : useContext;
        }

        public String getKey() {
            String useContext = m_roots.getUseContext();
            return useContext == null ? DEFAULT_USE_CONTEXT : useContext;
        }
    }
}
