/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.tree.TreeModel;
import com.arsdigita.bebop.tree.TreeModelBuilder;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryTreeModelLite;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.util.LockableImpl;

/**
 * Lists category tree.
 *
 * @author Tri Tran (tri@arsdigita.com)
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryTreeModelBuilder.java#7 $
 */
class CategoryTreeModelBuilder extends LockableImpl
        implements TreeModelBuilder {

    private SingleSelectionModel m_contextModel = null;

    public CategoryTreeModelBuilder() {
        this(null);
    }

    public CategoryTreeModelBuilder(SingleSelectionModel contextModel) {
        super();
        m_contextModel = contextModel;
    }

    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryTreeModelBuilder.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    public final TreeModel makeModel(final Tree tree, final PageState state) {
        final ContentSection section = CMS.getContext().getContentSection();
        final Category root = Category.getRootForObject(section, 
                                                        getUseContext(state));
        
        final CategoryTreeModelLite model = new CategoryTreeModelLite(root, "sortKey");

        return model;
    }
    private String getUseContext(PageState state) {
        String context = null;
        if (m_contextModel != null) {
            context = (String) m_contextModel.getSelectedKey(state);
            if ((CategoryUseContextModelBuilder.DEFAULT_USE_CONTEXT).equals(context)) {
                context = null;
            }
        }
        return context;
    }

}
