/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;

/**
 * The editing component for user defined items. Consists of a display
 * component which displays the form metadata, and a form which edits the
 * metadata as well as text.
 *
 * @author Xixi D'Moon (xdmoon@arsdigita.com)
 * @version $Revision: #5 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class SecondaryPageEditDynamic extends PageEditDynamic {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/SecondaryPageEditDynamic.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";


    /**
     * Construct a new SecondaryPageEditDynamic component
     *
     * @param itemModel The {@link ItemSelectionModel} which will
     *   be responsible for loading the current item
     *
     * @param parent The parent wizard which contains the form. The form
     *   may use the wizard's methods, such as stepForward and stepBack,
     *   in its process listener.
     */
    public SecondaryPageEditDynamic(ItemSelectionModel itemModel,
                                    AuthoringKitWizard parent) {
        super (itemModel, parent, null, false);
    }
    /**
     * Construct a new SecondaryPageEditDynamic component
     *
     * @param itemModel The {@link ItemSelectionModel} which will
     *   be responsible for loading the current item
     *
     * @param parent The parent wizard which contains the form. The form
     *   may use the wizard's methods, such as stepForward and stepBack,
     *   in its process listener.
     *
     * @param originatingType The content type to use for choosing dynamic
     *   components (if one UDCT inherits from another, type-specific attributes
     *   will be in separate steps).
     */
    public SecondaryPageEditDynamic(ItemSelectionModel itemModel,
                                    AuthoringKitWizard parent,
                                    ContentType originatingType) {

        super (itemModel, parent, originatingType, false);
    }

    protected void addNameTitleFields(DomainObjectPropertySheet sheet) {
        // do nothing for secondary steps
    }

}
