/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.Article;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.ImageDisplay;
import org.apache.log4j.Logger;


/**
 * A form which displays the newly selected image and prompts
 * for image caption.
 *
 * @author Stanislav Freidin (stas@arsdigita.com)
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #8 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class ImageSelectionForm extends BasicImageForm {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/ImageSelectionForm.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log =
        Logger.getLogger(ImageSelectionForm.class);

    private ImageDisplay m_display;

    /**
     * Construct a new ImageSelectionForm
     *
     * @param itemModel The {@link ItemSelectionModel} which will
     *   be responsible for loading the current item
     *
     * @param assetModel The {@link ItemSelectionModel} which will
     *   be responsible for loading the current image asset
     */
    public ImageSelectionForm(ItemSelectionModel itemModel,
                              ItemSelectionModel assetModel) {
        super("ImageSelectionForm", itemModel, assetModel);

        m_display = new ImageDisplay(getAssetSelectionModel());
        add(m_display, ColumnPanel.LEFT | ColumnPanel.FULL_WIDTH);
    }


    public void init(FormSectionEvent e) throws FormProcessException {
        // Do nothing.
    }

    // process: update image association
    public void process(FormSectionEvent e) throws FormProcessException {
        s_log.debug("Selecting Image");
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        Article item = this.getArticle(state);
        ImageAsset a = this.getImageAsset(state);

        if(a != null) {
            item.clearImages();
            item.addImage(a, (String)data.get(CAPTION));
            item.save();
            this.setImageAsset(state, a);
            s_log.debug("Image Selected");
        }
    }

    /**
     * @return the image display component
     */
    public ImageDisplay getImageDisplay() {
        return m_display;
    }

}
