/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.toolbox.ui.ContextBar;
import com.arsdigita.web.URL;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * <p>The context bar of the content center UI.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/WorkspaceContextBar.java#6 $
 */
class WorkspaceContextBar extends ContextBar {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/WorkspaceContextBar.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (WorkspaceContextBar.class);

    protected List entries(final PageState state) {
        final List entries = super.entries(state);

        final String centerTitle = lz("cms.ui.content_center");
        final String centerPath = Utilities.getWorkspaceURL();
        final URL url = URL.there(state.getRequest(), centerPath);

        entries.add(new Entry(centerTitle, url));

        return entries;
    }

    private static String lz(final String key) {
        return (String) ContentSectionPage.globalize(key).localize();
    }
}
