/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.util.SecurityConstants;
import com.arsdigita.toolbox.ui.ProxyComponent;
import com.arsdigita.util.Assert;

/**
 * @author Justin Ross
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/VisibilityComponent.java#7 $
 */
public class VisibilityComponent extends ProxyComponent
        implements SecurityConstants {
    private final String m_action;

    public VisibilityComponent(final Component child, final String action) {
        super(child);

        m_action = action;
    }

    public boolean isVisible(final PageState state) {
        return super.isVisible(state) && hasPermission(state);
    }

    public boolean hasPermission(final PageState state) {
        Assert.exists(m_action, String.class);

        return CMS.getContext().getSecurityManager().canAccess
            (state.getRequest(), m_action);
    }
}
