/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMSExcursion;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Document;
import com.arsdigita.web.Web;
import com.arsdigita.web.Application;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <p>The Item Search page.</p>
 *
 * @author Scott Seago (scott@arsdigita.com)
 * @version $Revision: #11 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class ItemSearchPage extends CMSPage  {
    private final static String XSL_CLASS = "CMS Admin";

    private TabbedPane m_tabbedPane;

    private ItemSearchBrowsePane m_browse;
    private ItemSearchPopup m_search;
    private BigDecimalParameter m_sectionId;

    public static final String CONTENT_SECTION = "section_id";

    /**
     * Construct a new ItemSearchPage
     */
    public ItemSearchPage() {
        super("Item Search", new SimpleContainer());

        setClassAttr("cms-admin");

        addGlobalStateParam
            (new BigDecimalParameter(ItemSearch.SINGLE_TYPE_PARAM));
        addGlobalStateParam(new StringParameter(ItemSearchPopup.WIDGET_PARAM));

        m_sectionId = new BigDecimalParameter(CONTENT_SECTION);
        addGlobalStateParam(m_sectionId);

        m_browse = getBrowsePane();
        m_search = getSearchPane();

        m_tabbedPane = createTabbedPane();
        m_tabbedPane.setIdAttr("page-body");
        add(m_tabbedPane);
    }


    /**
     * Creates, and then caches, the Browse pane. Overriding this
     * method to return null will prevent this tab from appearing.
     * Note: not implemented yet.
     */
    protected ItemSearchBrowsePane getBrowsePane() {
        if (m_browse == null) {
            m_browse = new ItemSearchBrowsePane();
        }

        return m_browse;
    }

    /**
     * Creates, and then caches, the Creation pane. Overriding this
     * method to return null will prevent this tab from appearing.
     */
    protected ItemSearchPopup getSearchPane() {
        if (m_search == null) {
            m_search = new ItemSearchPopup(ContentItem.DRAFT);
        }

        return m_search;
    }


    /**
     * Created the TabbedPane to use for this page. Sets the class
     * attribute for this tabbed pane. The default implementation uses a
     * {@link com.arsdigita.bebop.TabbedPane} and sets the class
     * attribute to "CMS Admin." This implementation also adds tasks,
     * content sections, and search panes.
     *
     * Developers can override this method to add only the tabs they
     * want, or to add additional tabs after the default CMS tabs are
     * added.
     */
    protected TabbedPane createTabbedPane() {
        TabbedPane pane = new TabbedPane();
        pane.setClassAttr(XSL_CLASS);
        addToPane(pane, "Browse", getBrowsePane());
        addToPane(pane, "Search", getSearchPane());
        pane.setDefaultPane(m_browse);
        //pane.addActionListener(this);
        return pane;
    }


    /**
     * Adds the specified component, with the specified tab name, to the
     * tabbed pane only if it is not null.
     *
     * @param pane The pane to which to add the tab
     * @param tabName The name of the tab if it's added
     * @param comp The component to add to the pane
     */
    protected void addToPane(TabbedPane pane, String tabName, Component comp) {
        if (comp != null) {
            pane.addTab(tabName, comp);
        }
    }


    /**
     * When a new tab is selected, reset the state of the
     * formerly-selected pane.
     *
     * @param event The event fired by selecting a tab
     */
    //public void actionPerformed(ActionEvent event) {
    //PageState state = event.getPageState();
    //Component pane = m_tabbedPane.getCurrentPane(state);

    //if ( pane == m_browse ) {
    // MP: reset tasks pane
    //} else if ( pane == m_search ) {
    //m_search.reset(state);
    //}
    //}

    /**
     * This strange voodoo from Dan. No idea what it does.
     */
    public void dispatch(final HttpServletRequest request,
                         final HttpServletResponse response,
                         RequestContext actx)
            throws IOException, ServletException {
        new CMSExcursion() {
            public void excurse()
                throws IOException, ServletException {
                ContentSection section = null;
                Application app = Web.getContext().getApplication();
                if (app instanceof ContentSection) {
                    section = (ContentSection)app;
                } else {
                    try {
                        section = new ContentSection
                            ((BigDecimal) m_sectionId.transformValue(request));
                    } catch (DataObjectNotFoundException ex) {
                        throw new UncheckedWrapperException(ex);
                    }
                }
                setContentSection(section);


                final Document doc = buildDocument(request, response);
                final PresentationManager pm =
                    Templating.getPresentationManager();

                pm.servePage(doc, request, response);
            }
        }.run();
    }
}
