/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.kernel.User;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/FormSecurityListener.java#9 $
 */
public class FormSecurityListener implements FormSubmissionListener {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/FormSecurityListener.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log = Logger.getLogger(FormSecurityListener.class);

    private final String m_action;
    private final ContentItemRequestLocal m_item;

    public FormSecurityListener(final String action,
                                final ContentItemRequestLocal item) {
        Assert.exists(action, String.class);

        m_action = action;
        m_item = item;
    }

    public FormSecurityListener(final String action) {
        this(action, null);
    }

    public final void submitted(final FormSectionEvent e)
            throws FormProcessException {
        final PageState state = e.getPageState();
        final User user = Web.getContext().getUser();
        final SecurityManager sm = Utilities.getSecurityManager(state);
        
        if (m_item == null) {
            if(sm.canAccess(user, m_action)) {
                return;
            }
        } else {

            final ContentItem item = m_item.getContentItem(state);
            
            if (sm.canAccess(user, m_action, item)) {
                return;
            }
        }

        throw new AccessDeniedException();
    }
}
