/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.persistence.DataQuery;

public abstract class DataQueryOptionPrintListener implements PrintListener {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/DataQueryOptionPrintListener.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public DataQueryOptionPrintListener() {
    }

    protected abstract DataQuery getDataQuery (PageState s);

    public void prepare(PrintEvent e) {
        PageState s = e.getPageState();
        OptionGroup w = (OptionGroup) e.getTarget();
        DataQuery dataQuery = getDataQuery(s);
        while (dataQuery.next()) {
            w.addOption(new Option(getKey(dataQuery),
                                   getValue(dataQuery)));
        }
    }

    public abstract String getKey(DataQuery d);

    public String getValue(DataQuery d) {
        return getKey(d);
    }
}
