/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.PageLocations;
import com.arsdigita.cms.Template;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import org.apache.log4j.Logger;

import java.math.BigDecimal;
import java.util.List;
import java.util.Stack;

/**
 * <p>The context bar of the content section UI.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/ContentSectionContextBar.java#13 $
 */
class ContentSectionContextBar extends WorkspaceContextBar {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/ContentSectionContextBar.java#13 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (ContentSectionContextBar.class);

    protected List entries(final PageState state) {
        final List entries = super.entries(state);
        final ContentSection section = CMS.getContext().getContentSection();
        final Stack folderEntryStack = new Stack();
        String currentFolderLabel = null;
        ParameterMap params = new ParameterMap();
        boolean isTemplate = false;
        BigDecimal templateID = null;

        if (CMS.getContext().hasContentItem()) {
            final ContentItem item = CMS.getContext().getContentItem();
            isTemplate = 
                item.getContentType().equals(ContentType.findByAssociatedObjectType(Template.BASE_DATA_OBJECT_TYPE));
            if (isTemplate) {
                templateID = item.getID();
            }
            ACSObject parent = item.getParent();

            while (!isTemplate && parent != null && parent instanceof ContentItem) {
                if (currentFolderLabel != null) {
                    final URL folderURL = URL.there
                        (state.getRequest(),
                         section.getPath() + "/" + PageLocations.SECTION_PAGE,
                         params);
                    folderEntryStack.push(new Entry(currentFolderLabel, folderURL));
                    currentFolderLabel = null;
                    params = new ParameterMap();
                }
                final ContentItem pitem = (ContentItem) parent;

                if (pitem instanceof Folder) {
                    final Folder folder = (Folder) pitem;
                    parent = folder.getParent();

                    currentFolderLabel = folder.getLabel();
                    if (parent != null || folder.equals(section.getRootFolder())) {
                        params.setParameter
                            (ContentSectionPage.SET_FOLDER, folder.getID());
                    }
                } else if (pitem instanceof ContentBundle) {
                    final ACSObject ppitem = pitem.getParent();

                    if (ppitem != null && ppitem instanceof Folder) {
                        final Folder folder = (Folder) ppitem;

                        parent = folder.getParent();
                        currentFolderLabel = folder.getLabel();
                        if (parent != null || folder.equals(section.getRootFolder())) {
                            params.setParameter
                                (ContentSectionPage.SET_FOLDER, folder.getID());
                        }
                    } else {
                        parent = null;
                    }
                } else {
                    parent = null;
                }
            }
            
        }

        if (isTemplate) {
            params.setParameter
                (ContentSectionPage.SET_TAB, new BigDecimal(ContentSectionPage.CONTENTTYPES_TAB));
            params.setParameter(ContentSectionPage.SET_TEMPLATE, templateID);
        }
        // add section-level entry. if this is for an item page, the URL will be for the root folder.
        final URL url = URL.there
            (state.getRequest(),
             section.getPath() + "/" + PageLocations.SECTION_PAGE,
             params);

            
        final String sectionTitle = lz("cms.ui.content_section");
        final String title = sectionTitle + ": " + section.getName();

        entries.add(new Entry(title, url));

        // add any folders to the path now
        while (!folderEntryStack.empty()) {
            entries.add(folderEntryStack.pop());
        }

        return entries;
    }

    private static String lz(final String key) {
        return (String) ContentSectionPage.globalize(key).localize();
    }
}
