/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.dispatcher.ContentSectionDispatcher;
import com.arsdigita.xml.Element;

/**
 * @deprecated Use ContentItemPane instead
 *
 * A Bebop component that takes a the {@link ContentItem} from the request and
 * renders it as XML. The XML can then be styled with XSL in order to insert the
 * object's properties into the page.
 *
 * @author <a href="mailto:scott@arsdigita.com">Scott Seago</a>
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/ContentItemRenderer.java#7 $
 *
 */

public class ContentItemRenderer extends DomainObjectRenderer {

    /* recursive depth of DomainObjectRenderer */
    public static final int XML_DEPTH = 3;

    /**
     * Construct a new <code>ContentItemRenderer</code>.
     *
     */
    public ContentItemRenderer() {
        super(new ItemSelectionModel("item_id"), XML_DEPTH);
    }

    /**
     * Generate XML for the domain object supplied by the
     * selection model.
     */
    public void generateXML(PageState state, Element parent) {
        ContentItem item = ContentSectionDispatcher.getContentItem(state.getRequest());
        Element e = generateXMLElement(item);
        if(e != null)
            e.addAttribute("id",getIdAttr());
        parent.addContent(e);
    }

}
