/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.globalization.GlobalizedMessage;

/**
 * @author Justin Ross
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/BaseDeleteForm.java#6 $
 */
public abstract class BaseDeleteForm extends BaseForm
        implements FormProcessListener {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/BaseDeleteForm.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    protected final Submit m_delete;
    protected final Submit m_cancel;

    public BaseDeleteForm(final Component message) {
        super("delete", new Label(gz("cms.ui.attention")));

        addComponent(message);

        m_delete = new Submit("delete", gz("cms.ui.delete"));
        addAction(m_delete);

        m_cancel = new Submit("cancel", gz("cms.ui.cancel"));
        addAction(m_cancel);

        addProcessListener(this);
    }

    public BaseDeleteForm(final GlobalizedMessage message) {
        this(new Label(message));
    }

    public final boolean isCancelled(final PageState state) {
        return m_cancel.isSelected(state);
    }
}
