/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.search;

import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.metadata.ObjectType;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainServiceInterfaceExposer;

import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.ContentPage;

import java.util.List;
import java.util.ArrayList;


/**
 * An implementation of DomainObjectTraversal that generates a 
 * finds all associated binary assets
 *
 * @version $Id: //cms/dev/src/com/arsdigita/cms/search/ContentPageAssetExtractor.java#5 $
 */
public class ContentPageAssetExtractor extends DomainObjectTraversal {

    private List m_content;

    public static final String TEXT_ASSET_DATA_OBJ =
        "com.arsdigita.cms.TextAsset";
    public static final String FILE_ASSET_DATA_OBJ =
        "com.arsdigita.cms.FileAsset";

    public ContentPageAssetExtractor() {
        m_content = new ArrayList();
    }

    public List getContent() {
        return m_content;
    }

    protected void beginObject(DomainObject obj,
                               String path) {
    }

    protected void endObject(DomainObject obj,
                             String path) {
    }

    protected void revisitObject(DomainObject obj,
                                 String path) {
    }

    protected void handleAttribute(DomainObject obj,
                                   String path,
                                   Property property) {
        Object value = DomainServiceInterfaceExposer.get(obj, property.getName());

        if (value != null &&
            property.isRole() && 
            (value instanceof DataObject)) {
                
            ObjectType assetType = ((DataObject)value).getOID().getObjectType();
            String assetTypeName = assetType.getQualifiedName();
            if (assetTypeName.equals(TEXT_ASSET_DATA_OBJ)) {
                // add the value of the text asset to search_content
                TextAsset ta = new TextAsset((DataObject)value);
                String text = ta.getText();
                if (text != null) {
                    text = com.arsdigita.util.StringUtils.htmlToText( text );
                    m_content.add(
                        new ContentPageRawContentProvider("text",
                                                          text.getBytes()));
                }
            } else if (assetTypeName.equals(FILE_ASSET_DATA_OBJ)) {
                // add the value of the file asset to search_content
                FileAsset fa = new FileAsset((DataObject)value);
                m_content.add(new ContentPageRawContentProvider("file",
                                                                fa.getContent()));
            }
        }
    }

    protected void beginRole(DomainObject obj,
                             String path,
                             Property property) {
    }

    protected void endRole(DomainObject obj,
                           String path,
                           Property property) {
    }


    protected void beginAssociation(DomainObject obj,
                                    String path,
                                    Property property) {
        DataAssociation association = 
            (DataAssociation)DomainServiceInterfaceExposer.get
            (obj, property.getName());

        if (association != null && 
            association.getObjectType().isSubtypeOf
            (FileAsset.BASE_DATA_OBJECT_TYPE)) {
            while (association.next()) {
                // add the value of the file asset to search_content
                FileAsset fa = new FileAsset(association.getDataObject());
                m_content.add(new ContentPageRawContentProvider("file",
                                                                fa.getContent()));
            }
        }
    }

    protected void endAssociation(DomainObject obj,
                                  String path,
                                  Property property) {
    }

}
