/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.web.URL;
import com.arsdigita.util.ResourceManager;

import java.io.File;

/***
 * A publishing destination, consisting of an absolute document root, a
 * directory in the file system, and the URL under which this directory is
 * accessed on the live server.
 * 
 * @author Jeff Teeters (teeters@arsdigita.com)
 * @author <a href="mailto:dlutter@redhat.com">David Lutterkort</a>
 * @version $Revision: #9 $ $DateTime: 2004/04/07 16:07:11 $
 */
class DestinationStub {

    private String m_documentRoot;
    private boolean m_sharedRoot;
    private String m_urlStub;
    private File m_file;

    /***
     * Constructor.  Ensures that document root is an absolute path.
     * @param docRoot either a relative or absolute path to the document root.
     * @param url url stub for associated server.
     ***/
    DestinationStub(String docRoot,
                    boolean sharedRoot,
                    String urlStub) {
        m_documentRoot = docRoot;
        m_sharedRoot = sharedRoot;
        m_urlStub = urlStub;

        m_file = new File(docRoot);
    }

    /**
     * The file representing the directory root
     */
    public File getFile() {
        return m_file;
    }

    /**
     * Returns true if the publishing root is on 
     * shared storage (NFS)
     */
    public boolean isSharedRoot() {
        return m_sharedRoot;
    }
    
    /**
     * Returns the URL stub for published items
     * eg /p2fs
     */
    public String getURLStub() {
        return m_urlStub;
    }

    public String toString() {
        return "Doc Root " + m_documentRoot +
            (isSharedRoot() ? " (shared)" : " (not shared)") +
            " live URL stub is " + getURLStub();
    }
}
