/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.portlet;

import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.ui.portlet.ContentDirectoryPortletRenderer;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.Portlet;


public class ContentDirectoryPortlet extends Portlet {

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.cms.portlet.ContentDirectoryPortlet";

    public ContentDirectoryPortlet(DataObject dataObject) {
        super(dataObject);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new ContentDirectoryPortletRenderer(this);
    }
}
