/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.util.UncheckedWrapperException;


/**
 * Lifecycle exception
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 */
public class PublishingException extends UncheckedWrapperException {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/PublishingException.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public PublishingException(String message) {
        super(message);
    }

    public PublishingException(Exception e) {
        this(e.getMessage());
    }

    public PublishingException(Throwable rootCause) {
        super(rootCause);
    }

    public PublishingException(String s, Throwable rootCause) {
        super(s, rootCause);
    }
}
