/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.installer.xml;


import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.ContentType;
import com.arsdigita.xml.XML;

import org.apache.log4j.Logger;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** Parses XML file definition of content types and loads them to the
 * database.
 *
 * @see ContentTypeInitializer
 * @author Nobuko Asakai <nasakai@redhat.com> */

public class XMLContentTypeHandler extends DefaultHandler {
    private static Logger s_log =
        Logger.getLogger(XMLContentTypeHandler.class.getName());



    private ArrayList m_types = new ArrayList();

    private ContentTypeHelper m_type;
    private ContentType m_contentType;
    private AuthoringKit m_authoringKit;
    private int m_nextOrder;

    private boolean m_including;

    public List getContentTypes() {
        return m_types;
    }

    public void startElement( String uri, String name,
                              String qName, Attributes atts) {
        if (name.equals("content-types") ) {
            s_log.debug("matched content-types");
        } else if (name.equals("content-type")) {
            s_log.debug("matched content-type");
            String parentType = atts.getValue("parentType");
            if (parentType != null ) {
                m_type = new UDCTHelper();
                s_log.debug("Creating UDCT");
            } else {
                m_type = new ContentTypeHelperImpl();
                s_log.debug("Creating regular content type");
            }

            // for now, the bundle and key are not used for the content
            // type but they could easily be added if the content type
            // object is changed.
            m_type.setLabel(atts.getValue("label"));
            m_type.setLabelBundle(atts.getValue("labelBundle"));
            m_type.setLabelKey(atts.getValue("labelKey"));
            m_type.setDescription(atts.getValue("description"));
            m_type.setDescriptionBundle(atts.getValue("descriptionBundle"));
            m_type.setDescriptionKey(atts.getValue("descriptionKey"));
            m_type.setObjectType(atts.getValue("objectType"));
            m_type.setClassName(atts.getValue("classname"));

            String internal = atts.getValue("isInternal");
            if (internal != null &&
                "yes".equals(internal)) {
                m_type.setInternal(true);
            }
            // UDCT stuff
            m_type.setParentType(parentType);
            m_type.setName(atts.getValue("name"));
            m_contentType = m_type.createType();
            m_types.add(m_contentType);
        } else if ( name.equals("authoring-kit") ) {
            if (!m_including) {
                s_log.debug("matched authoring-kit");
                if (atts.getValue("createComponent") != null) {
                    m_type.setCreateComponent(atts.getValue("createComponent"));
                }
                m_authoringKit = m_type.createAuthoringKit();
                m_nextOrder = 1;
            }
        } else if ( name.equals("authoring-step" )) {
            String label = atts.getValue("label");
            String labelKey = atts.getValue("labelKey");
            String labelBundle = atts.getValue("labelBundle");
            String description = atts.getValue("description");
            String descriptionKey = atts.getValue("descriptionKey");
            String descriptionBundle = atts.getValue("descriptionBundle");
            if (labelKey == null) {
                labelKey = label;
            }
            if (descriptionKey == null) {
                descriptionKey = description;
            }
            m_type.addAuthoringStep(labelKey, labelBundle,
                                    descriptionKey, descriptionBundle,
                                    atts.getValue("component"),
                                    new BigDecimal(m_nextOrder++)
                                    );
        } else if (name.equals("include")) {
            String file = atts.getValue("href");
            m_including = true;
            XML.parseResource(file, this);
            m_including = false;
        } else {
            s_log.error("None of the elements match! name: " + name
                        + " qName: " + qName + " URI: " + uri);
        }
    }

    public void endElement( String uri, String name,
                            String qName, Attributes atts) {
        if (name.equals("content-type")) {
            // reset the helper
            m_contentType.save();
            m_authoringKit.save();
            m_type.saveType();
            m_type = null;
        }
    }
}
