/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.installer;

import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.ContentItem;

/**
 * VersioningUpgrader
 *
 * @author <a href="mailto:jorris@redhat.com">Jon Orris</a>
 * @version $Revision: #4 $ $DateTime: 2004/04/07 16:07:11 $
 */
final class VersioningUpgrader {

    private static final String QUERY_TOP_ITEMS =
        "com.arsdigita.cms.topLevelItems";
    private static final String QUERY_ITEM = "item";

    /**
     * Update the master object for all the content items, by assuming
     * that all items whose parent is a folder are master objects.
     */
    static void updateMasterObject() {
        DataQuery dq = SessionManager.getSession().retrieveQuery(QUERY_TOP_ITEMS);
        ItemCollection c = new ItemCollection
            (new DataQueryDataCollectionAdapter(dq, QUERY_ITEM));

        try {
            while (c.next()) {
                ContentItem item = c.getContentItem();
                item.autoPropagateMaster(item);
            }
        } finally {
            c.close();
        }
    }

}
