/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.templating.PatternGenerator;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;

import com.arsdigita.mimetypes.MimeType;

import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSectionServlet;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.ItemTemplateMapping;
import com.arsdigita.cms.TemplateManager;
import com.arsdigita.cms.TemplateManagerFactory;

import javax.servlet.http.HttpServletRequest;

import java.util.List;
import java.util.ArrayList;

/**
 *  This looks to see if there is a given item and if there is it returns
 *  the oid for that item as the gererated value
 */
public class ItemTemplatePatternGenerator implements PatternGenerator {

    private static ContentItemDispatcher s_disp = new ContentItemDispatcher();

    public String[] generateValues(String key,
                                   HttpServletRequest req) {
        if (CMS.getContext().hasContentItem()) {
            ContentItem item = CMS.getContext().getContentItem();
            String context = getTemplateContext(req);

            ItemTemplateMapping mapping = 
                ItemTemplateMapping.getMapping
                (item, context,
                 MimeType.loadMimeType(Template.XSL_MIME_TYPE));

            Template template = null;
            if (mapping == null) {
                // there is no mapping so we try to get the default for the
                // content type
                template =
                    TemplateManagerFactory.getInstance().getDefaultTemplate
                    (item.getContentSection(), item.getContentType(), 
                     context, MimeType.loadMimeType(Template.XSL_MIME_TYPE));
            } else {
                template = mapping.getTemplate();
            } 

            if (template != null) {
                return new String[] { template.getOID().toString() };
            }
        }
        
        return new String[] {};
    }

    protected String getTemplateContext(HttpServletRequest req) {
        TemplateResolver templateResolver =
            s_disp.getTemplateResolver(CMS.getContext().getContentSection());
        RequestContext ctx = DispatcherHelper.getRequestContext();
        String templateURL = ctx.getRemainingURLPart();
        
        if (!templateURL.startsWith("/")) {
            templateURL = "/" + templateURL; 
        }
        
        if (templateURL.startsWith(ContentSectionServlet.PREVIEW)) {
            templateURL = templateURL.substring
                (ContentSectionServlet.PREVIEW.length());
        } 
            
        if (templateURL.startsWith("/")) {
            templateURL = templateURL.substring(1);
        } 
        
        String templateContext = null;
        int index = templateURL.indexOf("/");
        if (index > -1) {
            templateContext = templateURL.substring(0, index);
        }
        
        if (templateContext != null && 
            templateContext.startsWith
            (AbstractItemResolver.TEMPLATE_CONTEXT_PREFIX)) {
            templateContext =  templateContext.substring
                (AbstractItemResolver.TEMPLATE_CONTEXT_PREFIX.length());
            return templateContext;
        } else {
            // we assume it is the default public
            return TemplateManager.PUBLIC_CONTEXT;
        }
    }
}
