/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.dispatcher.ChainedDispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/**
 * Dispatches to a file
 * stored under the CMS package root
 * (<code>/packages/cms/www</code>).  This includes both unmanaged
 * files copied or created directly in the file system, as well as
 * pages and assets published to the file system from CMS.
 *
 * @author Karl Goldstein (karlg@arsdigita.com)
 * @version $Revision: #12 $ $DateTime: 2004/04/07 16:07:11 $
 **/
public class FileDispatcher implements ChainedDispatcher {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/FileDispatcher.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log =
        Logger.getLogger(ChainedDispatcher.class);

    public int chainedDispatch(HttpServletRequest request,
                               HttpServletResponse response,
                               RequestContext context)
        throws IOException, ServletException {

        File jspFile = getPackageFile(context);

        if (jspFile.exists() && !jspFile.isDirectory()) {
            String packageURL = context.getPageBase() + context.getRemainingURLPart();
            s_log.debug ("DISPATCHING to " + packageURL);

            // don't match folders, since they don't actually match a file
            if ( !packageURL.endsWith("/")) {
                s_log.debug ("DISPATCHING to " + packageURL);
                // Don't set caching headers - let JSP file do it if required
                //DispatcherHelper.maybeCacheDisable(response);
                DispatcherHelper.setRequestContext(request, context);
                DispatcherHelper.forwardRequestByPath(packageURL, request, response);
                return ChainedDispatcher.DISPATCH_BREAK;
            }
        }

        return ChainedDispatcher.DISPATCH_CONTINUE;
    }

    /**
     * Matches the request URL to a file in the package www directory.
     **/
    private File getPackageFile(RequestContext appContext) {

        ServletContext servletContext = appContext.getServletContext();

        String filePath = appContext.getRemainingURLPart();

        String packageDocRoot =
            servletContext.getRealPath(appContext.getPageBase());

        File jspFile = new File(packageDocRoot, filePath);

        return jspFile;
    }
}
