/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;


/**
 * <p>This <code>ContentPanel</code> component fetches
 * the {@link com.arsdigita.cms.dispatcher.XMLGenerator} for the content
 * section.</p>
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 */
public class ContentPanel extends SimpleComponent {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/ContentPanel.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public ContentPanel() {
        super();
    }

    /**
     * Fetches an XML Generator. This method can be overidden to fetch
     * any {@link com.arsdigita.cms.dispatcher.XMLGenerator}, but by default,
     * it fetches the <code>XMLGenerator</code> registered to the current
     * {@link com.arsdigita.cms.ContentSection}.
     *
     * @param state The page state
     */
    protected XMLGenerator getXMLGenerator(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        Assert.assertNotNull(section);
        return section.getXMLGenerator();
    }

    /**
     * Generates XML that represents a content item.
     *
     * @param state The page state
     * @param parent The parent DOM element
     * @see com.arsdigita.cms.dispatcher.XMLGenerator
     */
    public void generateXML(PageState state, Element parent) {
        if ( isVisible(state) ) {
            Element content = parent.newChildElement("cms:contentPanel", CMS.CMS_XML_NS);
            exportAttributes(content);

            // Take advantage of caching in the CMS Dispatcher.
            XMLGenerator xmlGenerator = getXMLGenerator(state);

            xmlGenerator.generateXML(state, content, null);
        }
    }

}
