/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.LegacyInitEvent;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.db.DbHelper;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.xml.XML;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.search.MetadataProviderRegistry;
import org.apache.log4j.Logger;


public abstract class ContentAssetInitializer extends CompoundInitializer {
    private static Logger s_log = Logger.getLogger(ContentAssetInitializer.class);

    protected ContentAssetInitializer(final String manifestFile) {
        final String url = RuntimeConfig.getConfig().getJDBCURL();
        final int database = DbHelper.getDatabaseFromURL(url);

        add(new PDLInitializer
            (new ManifestSource
             (manifestFile,
              new NameFilter(DbHelper.getDatabaseSuffix(database), "pdl"))));
    }

    public void init(LegacyInitEvent evt) {
        super.init(evt);

        final String traversal = getTraversalXML();
        XML.parseResource
            (traversal,
             new ContentAssetTraversalHandler(getProperty()));
        
        AuthoringKitWizard.registerAssetStep(
            getBaseType(),
            getAuthoringStep(),
            getAuthoringStepLabel(),
            getAuthoringStepDescription(),
            getAuthoringStepSortKey()
        );
    }
    
    /**
     * The base type against which the asset is defined,
     * typically com.arsdigita.cms.ContentPage
     */
    public abstract String getBaseType();

    
    /**
     * Returns the path to the XML file defintions for the
     * asset, eg /WEB-INF/traversal-adapters/com/arsdigita/cms/contentassets/FileAttachments.xml
     */
    public abstract String getTraversalXML();
    /**
     * The name of the association between the item
     * and the asset, eg 'fileAttachments'.
     */
    public abstract String getProperty();

    
    /**
     * The class of the authoring kit step
     */
    public abstract Class getAuthoringStep();

    /**
     * The label for the authoring step
     */
    public abstract GlobalizedMessage getAuthoringStepLabel();
    /**
     * The description for the authoring step
     */
    public abstract GlobalizedMessage getAuthoringStepDescription();
    /**
     * The sort key for the authoring step
     */
    public abstract int getAuthoringStepSortKey();
}
