/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;


/**
 * A domain object for maintaining template use
 * context information
 * @see com.arsdigita.cms.TemplateContextCollection
 * @author Daniel Berrange
 */
public class TemplateContext extends DomainObject {
    
    public static final String BASE_DATA_OBJECT_TYPE = 
        "com.arsdigita.cms.TemplateContext";

    public static final String CONTEXT = "context";
    public static final String LABEL = "label";
    public static final String DESCRIPTION = "description";
    
    public TemplateContext() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public TemplateContext(DataObject obj) {
        super(obj);
    }
    
    public static TemplateContext create(String context,
                                         String label,
                                         String description) {
        TemplateContext tc = new TemplateContext();
        tc.setContext(context);
        tc.setLabel(label);
        tc.setDescription(description);
        return tc;
    }

    public static TemplateContext retrieve(String context)
        throws DataObjectNotFoundException {
        DataCollection da = SessionManager.getSession()
            .retrieve(BASE_DATA_OBJECT_TYPE);
        da.setParameter(CONTEXT, context);

        try {
            if (da.next()) {
                return (TemplateContext)
                    DomainObjectFactory.newInstance(da.getDataObject());
            }
        } finally {
            da.close();
        }

        throw new DataObjectNotFoundException(
            "cannot find template context " + context
        );
    }

    public static TemplateContextCollection retrieveAll() {
        DataCollection da = SessionManager.getSession()
            .retrieve(BASE_DATA_OBJECT_TYPE);
        TemplateContextCollection c = new TemplateContextCollection(da);
        return c;
    }

    public String getContext() {
        return (String)get(CONTEXT);
    }

    public void setContext(String context) {
        set(CONTEXT, context);
    }

    public String getLabel() {
        return (String)get(LABEL);
    }

    public void setLabel(String label) {
        set(LABEL, label);
    }

    public String getDescription() {
        return (String)get(DESCRIPTION);
    }

    public void setDescription(String description) {
        set(DESCRIPTION, description);
    }
}
