/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;

/**
 * This class contains a collection of {@link SectionTemplateMapping}s
 *
 * @author Stanislav Freidin (sfreidin@arsdigita.com)
 * @version $Id: //cms/dev/src/com/arsdigita/cms/SectionTemplateCollection.java#8 $
 *
 * @see com.arsdigita.domain.DomainCollection
 * @see com.arsdigita.persistence.DataCollection
 * @see com.arsdigita.cms.ItemTemplateCollection
 */
class SectionTemplateCollection extends TemplateCollection {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/SectionTemplateCollection.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     **/
    public SectionTemplateCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Returns a <code>DomainObject</code> for the current position in
     * the collection.
     *
     */
    public DomainObject getDomainObject() {
        return new SectionTemplateMapping(m_dataCollection.getDataObject());
    }

    /**
     * Return the current template
     */
    public Template getTemplate() {
        SectionTemplateMapping m = (SectionTemplateMapping)getDomainObject();
        if(m == null) return null;
        return m.getTemplate();
    }

    /**
     * Return the current use context
     */
    public String getUseContext() {
        SectionTemplateMapping m = (SectionTemplateMapping)getDomainObject();
        if(m == null) return null;
        return m.getUseContext();
    }

    /**
     * Return true if the current template is the default for its context
     */
    public Boolean isDefault() {
        SectionTemplateMapping m = (SectionTemplateMapping)getDomainObject();
        if(m == null) return null;
        return m.isDefault();
    }

}
