/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.domain.DomainObject;

/**
 * <span style="color:red">Deprecated</span>.
 * @deprecated Use {@link com.arsdigita.kernel.ui.DomainObjectSelectionModel}
 *
 * <p>A {@link SingleSelectionModel} which loads an item from the database. The
 * {@link SingleSelectionModel#isSelected(PageState)} method will return true if
 * it was possible to load the item.</p>
 *
 * @version $Id: //cms/dev/src/com/arsdigita/cms/DomainObjectSelectionModel.java#11 $
 */
public interface DomainObjectSelectionModel extends SingleSelectionModel {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/DomainObjectSelectionModel.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Return the item which was selected and loaded from the database,
     * using the values supplied in PageState.
     *
     * @param state The page state
     * @return The item domain object, or null if no item is
     *         selected.
     *
     * @deprecated
     */
    DomainObject getSelectedObject(PageState state);

    /**
     * Select the given domain object. Should extract the selected
     * key from the object in some manner, and call setSelectedKey
     * to change the key.
     *
     * @param state The page state
     * @param object The domain object to set
     * @deprecated
     */
    void setSelectedObject(PageState state, DomainObject object);

}
