/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;

/**
 * This class contains a collection of {@link
 * com.arsdigita.cms.ContentType content types}.
 *
 * @author Jack Chung (flattop@arsdigita.com)
 * @version $Revision: #10 $ $Date: 2004/04/07 $
 *
 * @see com.arsdigita.domain.DomainCollection
 * @see com.arsdigita.persistence.DataCollection
 */
public class ContentTypeCollection extends DomainCollection {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ContentTypeCollection.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     */
    public ContentTypeCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Set the order of this Collection. This method needs to be called
     * before <code>next()</code> is called on this collection.
     *
     */
    public void addOrder(String order) {
        m_dataCollection.addOrder(order);
    }


    public Filter addFilter(String conditions) {
        return m_dataCollection.addFilter(conditions);
    }


    /**
     * Returns a <code>DomainObject</code> for the current position in
     * the collection.
     *
     */
    public DomainObject getDomainObject() {
        return new ContentType(m_dataCollection.getDataObject());
    }

    /**
     * Returns a <code>LifecycleDefinition</code> for the current position in
     * the collection.
     *
     */
    public ContentType getContentType() {
        return (ContentType) getDomainObject();
    }

    /**
     * Reset this collection
     */
    public void reset() {
        m_dataCollection.reset();
    }


}
