/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;

import java.math.BigDecimal;

/**
 * This class associates an {@link com.arsdigita.cms.AuthoringKit
 * authoring kit} with {@link com.arsdigita.cms.AuthoringStep
 * authoring steps} in a particular order.
 *
 * @author Jack Chung (flattop@arsdigita.com)
 * @version $Revision: #10 $ $Date: 2004/04/07 $
 */
class AuthoringKitStepAssociation extends DomainObject {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/AuthoringKitStepAssociation.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";


    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.cms.AuthoringKitStepAssociation";

    protected static final String KIT_ID = "kitId";
    protected static final String STEP_ID = "stepId";
    protected static final String ORDERING = "ordering";


    public AuthoringKitStepAssociation() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public AuthoringKitStepAssociation(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public AuthoringKitStepAssociation(DataObject obj) {
        super(obj);
    }


    public BigDecimal getKitID() {
        return (BigDecimal) get(KIT_ID);
    }

    public void setKit(AuthoringKit kit) {
        set(KIT_ID, kit.getID());
    }

    public BigDecimal getStepID() {
        return (BigDecimal) get(STEP_ID);
    }

    public void setStep(AuthoringStep step) {
        set(STEP_ID, step.getID());
    }

    public BigDecimal getOrdering() {
        return (BigDecimal) get(ORDERING);
    }

    public void setOrdering(BigDecimal ordering) {
        set(ORDERING, ordering);
    }
}
