--
-- Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/postgres/fk_to_deferred.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $
create or replace function tmp_deffer_fk()
  returns integer as '
  declare 
    c record;
  begin 
    for c in select ''alter table '' || tab.relname || '' drop constraint '' || uc.conname as drop_cmd
	      from pg_constraint uc LEFT OUTER JOIN pg_class fktab ON (uc.confrelid = fktab.oid)
       	 , pg_class tab
	      WHERE uc.conrelid = tab.oid
	        and tab.relname in (''publish_to_fs_queue'', ''publish_to_fs_files'')
	        and uc.contype = ''f''
	        and fktab.relname = ''web_hosts''
   loop
      execute c.drop_cmd;
    end loop;
    return 1;
end; ' language 'plpgsql'
;

select tmp_deffer_fk();

alter table publish_to_fs_files add 
    constraint publi_to_fs_fil_hos_id_f_nwho1 foreign key (host_id)
      references web_hosts(host_id) deferrable initially deferred;

alter table publish_to_fs_queue add 
    constraint publi_to_fs_que_hos_id_f_9wfcg foreign key (host_id)
      references web_hosts(host_id) deferrable initially deferred;

drop function tmp_deffer_fk();
