--
-- Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/oracle-se/upgrade/5.2.1-6.0.0/update-lifecycles.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $


-- remove the referential integrity constraint from ACS_OBJECT_LIFECYCLE_MAP.OBJECT_ID
DECLARE
  ref_cons_name VARCHAR(30);
  drop_cmd      VARCHAR(100);
BEGIN
  select c.constraint_name into ref_cons_name
    from user_constraints c,
         user_cons_columns r1,
         user_cons_columns r2
   where c.constraint_type = 'R'
     and c.constraint_name = r1.constraint_name
     and r1.table_name = 'ACS_OBJECT_LIFECYCLE_MAP'
     and r1.column_name = 'OBJECT_ID'
     and c.r_constraint_name = r2.constraint_name
     and r2.table_name = 'ACS_OBJECTS'
     and r2.column_name = 'OBJECT_ID';
  if SQL%NOTFOUND then
    raise_application_error(-20000, 'Constraint name for ACS_OBJECT_LIFECYCLE_MAP not found.  ' ||
                                    'This script may have already been run, please verify.');
  end if;

  drop_cmd := 'alter table acs_object_lifecycle_map drop constraint ' || ref_cons_name;

  execute immediate drop_cmd;

EXCEPTION
  when NO_DATA_FOUND then
    raise_application_error(-20000, 'Constraint name for ACS_OBJECT_LIFECYCLE_MAP not found.  ' ||
                                    'This script may have already been run, please verify.');
END;
/

-- add the new ITEM_ID column
alter table acs_object_lifecycle_map add (
  item_id INTEGER
          constraint acs_obj_lif_map_ite_id_f_2cb3k
          references acs_objects(object_id) 
);

-- set the ITEM_ID column to the old OBJECT_ID
update acs_object_lifecycle_map
   set item_id = object_id;

-- make the updated ITEM_ID column not null
alter table acs_object_lifecycle_map modify (
  item_id constraint acs_obj_cycle_map_item_id_nn
          not null);

-- Update ACS_OBJECT_LIFECYCLE_MAP.OBJECT_ID with new, unused
-- ids.  This is not technically necessary, but we do it for clarity.
update acs_object_lifecycle_map
   set object_id = acs_object_id_seq.nextval;

-- remove the unused VERSION_TAG column
alter table acs_object_lifecycle_map
 drop (version_tag);
