--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/oracle-se/upgrade/5.1.0-5.2.0/change-phase-duration-granularity.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $


-- See SDM #225499.
--
-- In a nutshell, it is silly to meausure lifecycle phase default
-- duration and delay with a millisecond precision. We are bumping up
-- the granularity to one minute to accomdate the fact that the
-- "integer" type on Postgres is only 32 bits. The alternative would
-- have been to change the Postgres type of the corresponding columns
-- from "integer" to "bigint" (which is 64 bits) by forking the PDL
-- file.  This would only serve to perpetuate this whole millisecond
-- granularity folly.
--
-- As a result, the duration and delay upper limit goes from 25 days
-- to 4081 years on Postgres.

update phase_definitions
set
 default_duration = default_duration / 60000,
 default_delay = default_delay / 60000;
