--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/default/content-section/table-content_types.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

create table content_types (
  type_id	  integer 
                  constraint content_types_type_id_fk references
		  acs_objects
		  constraint content_types_pk primary key,
  object_type     varchar(100) 
		  constraint content_types_object_type_un unique
		  constraint content_types_object_type_nil not null,
  label		  varchar(1000) not null,
  description	  varchar(4000),
  classname       varchar(200),
  is_internal     char(1) default '0' not null
                  constraint content_types_is_internal_ck
                  check ( is_internal in ('0', '1') ),
  item_form_id    integer
                  constraint content_types_form_id_fk references
	          bebop_components (component_id)
);
