--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/default/content-section/table-cms_section_template_map.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

create table cms_section_template_map (
  mapping_id    integer 
                constraint cms_stm_mapping_id_fk references 
                acs_objects,
  section_id    integer 
                constraint cms_stm_section_id_fk references 
                content_sections,
  type_id       integer 
                constraint cms_stm_type_id_fk references 
                content_types,
  template_id   integer 
                constraint cms_stm_template_id_fk references 
                cms_templates,
  use_context   varchar(200) default 'public'
                constraint cms_stm_use_ctx_fk references
                cms_template_use_contexts,
  is_default    varchar(1) default '0' not null,
                constraint cms_stm_is_def_bool check
		(is_default in ('1', '0')),
  constraint cms_section_template_map_pk primary key(mapping_id)
);
