--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/default/content-section/table-cms_items.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

create table cms_items (
  item_id	  integer
                  constraint cms_items_item_id_fk references
		  acs_objects
		  constraint cms_items_pk primary key,
  parent_id	  integer
                  constraint cms_items_parent_id_fk references
		  acs_objects,
  name		  varchar(200)
		  constraint cms_items_name_nil
                  not null,
  type_id         integer
		  constraint cms_items_type_id_fk
                  references content_types,
  version         varchar(200) not null
                  constraint cms_items_version_ck
                  check (version in ('live', 'draft', 'pending', 'archived')),
  language        char(2),
  section_id      integer,
                  -- Do not add fk constraints on a denormalized column.
                  --constraint cms_items_section_id_fk
                  --references content_sections on delete cascade,
  ancestors       varchar(3209),
  master_id       integer
                  constraint master_id_fk references cms_items
);
