--
-- Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/postgres/upgrade/6.0.1-6.1.0/create-cms_user_home_folder_map.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $
create table cms_user_home_folder_map (
    map_id INTEGER not null
        constraint cms_use_hom_fol_map_ma_p_h1be4
          primary key,
        -- referential constraint for map_id deferred due to circular dependencies
    user_id NUMERIC,
        -- referential constraint for user_id deferred due to circular dependencies
    section_id NUMERIC,
        -- referential constraint for section_id deferred due to circular dependencies
    folder_id INTEGER not null
        -- referential constraint for folder_id deferred due to circular dependencies
);
alter table cms_user_home_folder_map add
    constraint cms_use_hom_fol_map_fo_f_etja4 foreign key (folder_id)
      references cms_folders(folder_id);
alter table cms_user_home_folder_map add
    constraint cms_use_hom_fol_map_ma_f_ip3qg foreign key (map_id)
      references acs_objects(object_id);
alter table cms_user_home_folder_map add
    constraint cms_use_hom_fol_map_se_f_7arnr foreign key (section_id)
      references content_sections(section_id);
alter table cms_user_home_folder_map add
    constraint cms_use_hom_fol_map_us_f_g0a5f foreign key (user_id)
      references users(user_id);
