/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.DataQueryOptionPrintListener;
import com.arsdigita.cms.ui.workflow.TaskRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Group;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TooManyListenersException;

class TaskAddRole
extends CMSForm {
    private final TaskRequestLocal m_task;
    private final OptionGroup m_roles;
    private final Submit m_add;
    private final Submit m_cancel;

    TaskAddRole(TaskRequestLocal task) {
        super("GroupAssignForm");
        this.m_task = task;
        this.add((Component)new Label(TaskAddRole.gz("cms.ui.workflow.task.roles")), 8);
        this.m_roles = new CheckboxGroup("roles");
        this.add((Component)this.m_roles);
        try {
            this.m_roles.addPrintListener((PrintListener)new RoleOptionPrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("TooManyListeners: " + e.getMessage(), (Throwable)e);
        }
        SimpleContainer submits = new SimpleContainer();
        this.add((Component)submits, 66);
        this.m_add = new Submit("add", TaskAddRole.gz("cms.ui.finish"));
        submits.add((Component)this.m_add);
        this.m_cancel = new Submit("cancel", TaskAddRole.gz("cms.ui.cancel"));
        submits.add((Component)this.m_cancel);
        this.addInitListener(new InitListener());
        this.addSubmissionListener(new SubmissionListener());
        this.addProcessListener(new ProcessListener());
    }

    private static GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(String key) {
        return (String)TaskAddRole.gz(key).localize();
    }

    private class RoleOptionPrintListener
    extends DataQueryOptionPrintListener {
        public static final String QUERY_NAME = "com.arsdigita.cms.getStaffRoles";

        protected DataQuery getDataQuery(PageState s) {
            ContentSection section = CMS.getContext().getContentSection();
            Session session = SessionManager.getSession();
            DataQuery query = session.retrieveQuery(QUERY_NAME);
            Filter parentFilter = query.addFilter("sectionId = :sectionId");
            parentFilter.set("sectionId", (Object)section.getID());
            query.addOrder("upper(name)");
            return query;
        }

        public String getKey(DataQuery d) {
            return d.get("groupId").toString();
        }

        public String getValue(DataQuery d) {
            return (String)d.get("name");
        }
    }

    private class SubmissionListener
    implements FormSubmissionListener {
        private SubmissionListener() {
        }

        public final void submitted(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            SecurityManager sm = Utilities.getSecurityManager(state);
            if (!sm.canAccess(state.getRequest(), "workflow_admin")) {
                throw new FormProcessException(TaskAddRole.lz("cms.ui.workflow.insufficient_privileges"));
            }
        }
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            CMSTask task = TaskAddRole.this.m_task.getTask(state);
            task.removeAllGroupAssignees();
            String[] roles = (String[])TaskAddRole.this.m_roles.getValue(state);
            if (roles != null) {
                for (int i = 0; i < roles.length; ++i) {
                    task.assignGroup(new Group(new BigDecimal(roles[i])));
                }
            }
            task.save();
        }
    }

    private class InitListener
    implements FormInitListener {
        private InitListener() {
        }

        public final void init(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            CMSTask task = TaskAddRole.this.m_task.getTask(state);
            Iterator iter = task.getAssignedGroups();
            ArrayList<String> list = new ArrayList<String>();
            while (iter.hasNext()) {
                list.add(((Group)iter.next()).getID().toString());
            }
            TaskAddRole.this.m_roles.setValue(state, (Object)list.toArray());
        }
    }
}

