/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ui.BaseDeleteForm;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.VisibilityComponent;
import com.arsdigita.cms.ui.workflow.TaskAddForm;
import com.arsdigita.cms.ui.workflow.TaskEditForm;
import com.arsdigita.cms.ui.workflow.TaskItemPane;
import com.arsdigita.cms.ui.workflow.TaskRequestLocal;
import com.arsdigita.cms.ui.workflow.TaskTableModelBuilder;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.ModalPanel;
import com.arsdigita.toolbox.ui.PropertyList;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.TaskException;
import com.arsdigita.workflow.simple.Workflow;
import java.math.BigDecimal;
import java.util.List;

abstract class BaseWorkflowItemPane
extends BaseItemPane {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/BaseWorkflowItemPane.java#13 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    final WorkflowRequestLocal m_workflow;
    final TaskRequestLocal m_task;
    ActionGroup m_actionGroup;
    final TaskTable m_tasks;
    final SimpleContainer m_detailPane;
    final TaskItemPane m_taskPane;
    final SummarySection m_summarySection;
    private static final String[] s_columns = new String[]{BaseWorkflowItemPane.lz("cms.ui.name"), BaseWorkflowItemPane.lz("cms.ui.description"), BaseWorkflowItemPane.lz("cms.ui.workflow.task.dependencies"), BaseWorkflowItemPane.lz("cms.ui.workflow.task.state")};

    public BaseWorkflowItemPane(WorkflowRequestLocal workflow, ActionLink editLink, ActionLink deleteLink) {
        this.m_workflow = workflow;
        this.m_tasks = new TaskTable();
        this.m_task = new TaskSelectionRequestLocal();
        this.m_detailPane = new SimpleContainer();
        FinishLink taskFinishLink = new FinishLink();
        ActionLink taskAddLink = new ActionLink((Component)new Label(BaseWorkflowItemPane.gz("cms.ui.workflow.task.add")));
        TaskAddForm taskAddForm = new TaskAddForm(this.m_workflow, this.m_tasks.getRowSelectionModel());
        ActionLink taskEditLink = new ActionLink((Component)new Label(BaseWorkflowItemPane.gz("cms.ui.workflow.task.edit")));
        TaskEditForm taskEditForm = new TaskEditForm(this.m_workflow, this.m_task);
        ActionLink taskDeleteLink = new ActionLink((Component)new Label(BaseWorkflowItemPane.gz("cms.ui.workflow.task.delete")));
        TaskDeleteForm taskDeleteForm = new TaskDeleteForm();
        ActionLink backLink = new ActionLink((Component)new Label(BaseWorkflowItemPane.gz("cms.ui.workflow.task.return")));
        backLink.addActionListener((ActionListener)new ModalPanel.ResetListener((ModalPanel)this));
        this.m_taskPane = new TaskItemPane(this.m_workflow, this.m_task, taskFinishLink, taskEditLink, taskDeleteLink, backLink);
        this.m_summarySection = new SummarySection(editLink, deleteLink);
        this.m_detailPane.add((Component)this.m_summarySection);
        this.m_detailPane.add((Component)new TaskSection(taskAddLink));
        this.add((Component)this.m_detailPane);
        this.setDefault((Component)this.m_detailPane);
        this.add((Component)this.m_taskPane);
        this.add((Component)taskAddForm);
        this.add((Component)taskEditForm);
        this.add((Component)taskDeleteForm);
        this.connect(this.m_tasks, 0, (Component)this.m_taskPane);
        this.connect(taskAddLink, (FormSection)taskAddForm);
        this.connect((FormSection)taskAddForm, (Component)this.m_taskPane);
        this.connect(taskEditLink, (FormSection)taskEditForm);
        this.connect((FormSection)taskEditForm);
        this.connect(taskDeleteLink, (FormSection)taskDeleteForm);
        this.connect((FormSection)taskDeleteForm, (Component)this.m_detailPane);
    }

    public void reset(PageState state) {
        super.reset(state);
        this.m_tasks.getRowSelectionModel().clearSelection(state);
    }

    private class TaskTable
    extends Table {
        public TaskTable() {
            super((TableModelBuilder)new TaskTableModelBuilder(BaseWorkflowItemPane.this.m_workflow), (Object[])s_columns);
            this.setEmptyView((Component)new Label(BaseWorkflowItemPane.gz("cms.ui.workflow.task.none")));
            this.getColumn(0).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(true));
        }
    }

    class TaskSection
    extends Section {
        TaskSection(ActionLink taskAddLink) {
            this.setHeading((Component)new Label(BaseWorkflowItemPane.gz("cms.ui.workflow.tasks")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)BaseWorkflowItemPane.this.m_tasks);
            group.addAction((Component)new AdminVisible((Component)taskAddLink), "add");
        }
    }

    class SummarySection
    extends Section {
        SummarySection(ActionLink editLink, ActionLink deleteLink) {
            this.setHeading((Component)new Label(BaseWorkflowItemPane.gz("cms.ui.workflow.details")));
            BaseWorkflowItemPane.this.m_actionGroup = new ActionGroup();
            this.setBody((Component)BaseWorkflowItemPane.this.m_actionGroup);
            BaseWorkflowItemPane.this.m_actionGroup.setSubject((Component)new Properties());
            BaseWorkflowItemPane.this.m_actionGroup.addAction((Component)new AdminVisible((Component)editLink), "edit");
            BaseWorkflowItemPane.this.m_actionGroup.addAction((Component)new AdminVisible((Component)deleteLink), "delete");
        }

        private class Properties
        extends PropertyList {
            private Properties() {
            }

            protected final List properties(PageState state) {
                List props = super.properties(state);
                Workflow flow = (Workflow)((SummarySection)SummarySection.this).BaseWorkflowItemPane.this.m_workflow.get(state);
                props.add(new PropertyList.Property(BaseWorkflowItemPane.gz("cms.ui.name"), flow.getLabel()));
                props.add(new PropertyList.Property(BaseWorkflowItemPane.gz("cms.ui.description"), flow.getDescription()));
                props.add(new PropertyList.Property(BaseWorkflowItemPane.gz("cms.ui.workflow.current_state"), flow.getStateString()));
                props.add(new PropertyList.Property(BaseWorkflowItemPane.gz("cms.ui.workflow.num_tasks"), String.valueOf(flow.getTaskCount())));
                return props;
            }
        }
    }

    private class TaskSelectionRequestLocal
    extends TaskRequestLocal {
        private TaskSelectionRequestLocal() {
        }

        protected final Object initialValue(PageState state) {
            String id = BaseWorkflowItemPane.this.m_tasks.getRowSelectionModel().getSelectedKey(state).toString();
            return new CMSTask(new BigDecimal(id));
        }
    }

    private class TaskDeleteForm
    extends BaseDeleteForm {
        TaskDeleteForm() {
            super((Component)new Label(TaskDeleteForm.gz("cms.ui.workflow.task.delete_prompt")));
            this.addSecurityListener("workflow_admin");
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            BaseWorkflowItemPane.this.m_task.getTask(state).delete();
            BaseWorkflowItemPane.this.m_tasks.getRowSelectionModel().clearSelection(state);
        }
    }

    private class FinishLink
    extends ActionLink {
        FinishLink() {
            super((Component)new Label(BaseWorkflowItemPane.gz("cms.ui.workflow.task.finish")));
            this.addActionListener(new Listener());
            this.addActionListener((ActionListener)new ModalPanel.ResetListener((ModalPanel)BaseWorkflowItemPane.this));
        }

        public final boolean isVisible(PageState state) {
            return BaseWorkflowItemPane.this.m_task.getTask(state).isEnabled();
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            public final void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                try {
                    ((FinishLink)FinishLink.this).BaseWorkflowItemPane.this.m_task.getTask(state).finish(Web.getContext().getUser());
                }
                catch (TaskException te) {
                    throw new UncheckedWrapperException((Throwable)te);
                }
            }
        }
    }

    protected class AdminVisible
    extends VisibilityComponent {
        public AdminVisible(Component child) {
            super(child, "workflow_admin");
        }
    }
}

